implementation module mstate


import	StdInt
import	osmenu
import	StdMenuDef
import	commondef, id, menudefaccess, menuhandle


mstateFatalError :: String String -> .x
mstateFatalError rule error
	= FatalError rule "mstate" error


/*	The MenuHandle` data type.
	This type is a subtype of the MenuHandle data type. The MenuHandle` data type 
	takes the projection of those fields of the (MenuHandle ls ps) data type that 
	do not depend on the type variables {ls,ps}.
*/

::	MenuHandle`
	=	{	mHandle`	:: OSMenu						// The handle to the menu as created by the OS
		,	mMenuId`	:: Id							// The menu id
		,	mOSMenuNr`	:: OSMenuNr						// The OSMenuNr
//		,	mMacId`		:: Int							// The mac id
		,	mTitle`		:: String						// The title of the menu
		,	mSelect`	:: Bool							// The MenuSelect==Able (by default True)
//		,	mLS`		:: Bool							// The menu has local state (True iff works on local state)
		,	mItems`		:: [MenuElementHandle`]			// The menu elements of this menu
		}
::	MenuElementHandle`
	= 	MenuItemHandle`			MenuItemHandle`
	|	MenuReceiverHandle`		MenuReceiverHandle`
	| 	SubMenuHandle`			SubMenuHandle`
	|	RadioMenuHandle`		RadioMenuHandle`
	| 	MenuSeparatorHandle`	MenuSeparatorHandle`
	|	MenuListLSHandle`		[MenuElementHandle`]
	|	MenuExtendLSHandle`		[MenuElementHandle`]
	|	MenuChangeLSHandle`		[MenuElementHandle`]
::	MenuItemHandle`
	=	{	mItemId`		:: Maybe Id
		,	mItemKey`		:: Maybe Char
		,	mItemTitle`		:: Title
		,	mItemSelect`	:: Bool
		,	mItemMark`		:: Bool
//		,	mItemLS`		:: Bool
		,	mItemAtts`		:: [MenuAttribute`]
		,	mOSMenuItem`	:: OSMenuItem
		}
::	MenuReceiverHandle`
//	=	{	mReceiverLS`	:: Bool
	=	{	mReceiverId`	:: Id
		,	mReceiverSelect`:: Bool
		}
::	SubMenuHandle`
	=	{	mSubHandle`		:: OSMenu
		,	mSubMenuId`		:: Maybe Id
		,	mSubOSMenuNr`	:: OSSubMenuNr
//		,	mSubMacId`		:: Int
		,	mSubItems`		:: [MenuElementHandle`]
		,	mSubTitle`		:: Title
		,	mSubSelect`		:: Bool
//		,	mSubLS`			:: Bool
		,	mSubAtts`		:: [MenuAttribute`]
		}
::	RadioMenuHandle`
	=	{	mRadioId`		:: Maybe Id
		,	mRadioIndex`	:: Int						// If mRadioItems==[] 0, otherwise 1..#mRadioItems
		,	mRadioItems`	:: [MenuElementHandle`]
		,	mRadioSelect`	:: Bool
//		,	mRadioLS`		:: Bool
		,	mRadioAtts`		:: [MenuAttribute`]
		}
::	MenuSeparatorHandle`
	=	{	mSepId`			:: Maybe Id
//		,	mSepLS`			:: Bool
		}
::	MenuAttribute`										//	Default:
	=	MenuId`				Id							//	no Id
	|	MenuSelectState`	SelectState					//	menu(item) Able
	|	MenuShortKey`		Char						//	no ShortKey
	|	MenuMarkState`		MarkState					//	NoMark


getMenuHandle` :: !(MenuHandle .ls .ps) -> (!MenuHandle`,!MenuHandle .ls .ps)
getMenuHandle` mH=:{mHandle,mMenuId,mOSMenuNr/*PA---,mMacId*/,mTitle,mSelect/*PA---,mLS*/,mItems=items}
	# (items`,items)	= getMenuElementHandles items
	= (	{mHandle`=mHandle,mMenuId`=mMenuId,mOSMenuNr`=mOSMenuNr/*PA---,mMacId`=mMacId*/,mTitle`=mTitle,mSelect`=mSelect/*PA---,mLS`=mLS*/,mItems`=items`}
	  ,	{mH & mItems=items}
	  )
where
	getMenuElementHandles :: ![MenuElementHandle .ls .ps] -> (![MenuElementHandle`],![MenuElementHandle .ls .ps])
	getMenuElementHandles [itemH:itemHs]
		# (itemH`, itemH)	= getMenuElementHandle  itemH
		  (itemHs`,itemHs)= getMenuElementHandles itemHs
		= ([itemH`:itemHs`],[itemH:itemHs])
	where
		getMenuElementHandle :: !(MenuElementHandle .ls .ps) -> (!MenuElementHandle`,!MenuElementHandle .ls .ps)
		getMenuElementHandle (MenuItemHandle itemH=:{mItemId,mItemKey,mItemTitle,mItemSelect,mItemMark/*PA---,mItemLS*/,mItemAtts=atts,mOSMenuItem})
			# (atts`,atts)		= getMenuAttributes atts
			= ( MenuItemHandle`
				{	mItemId`	= mItemId
				,	mItemKey`	= mItemKey
				,	mItemTitle`	= mItemTitle
				,	mItemSelect`= mItemSelect
				,	mItemMark`	= mItemMark
	// PA---	,	mItemLS`	= mItemLS
				,	mItemAtts`	= atts`
				,	mOSMenuItem`= mOSMenuItem
				}
			  , MenuItemHandle 
				{itemH & mItemAtts=atts}
			  )
		getMenuElementHandle (MenuReceiverHandle recH=:{/*PA---mReceiverLS,*/mReceiverHandle={rId,rSelect}})
		=	( MenuReceiverHandle`
			//	{	mReceiverLS`	= mReceiverLS
				{	mReceiverId`	= rId
				,	mReceiverSelect`= rSelect==Able		// PA: SelectState to Bool
				}
			, MenuReceiverHandle recH
			)
		getMenuElementHandle (SubMenuHandle
								subH=:{mSubHandle,mSubMenuId,mSubOSMenuNr/*PA---,mSubMacId*/,mSubItems=items,mSubTitle,mSubSelect/*PA---,mSubLS*/,mSubAtts=atts})
		#	(items`,items)	= getMenuElementHandles items
			(atts`, atts)	= getMenuAttributes atts
		=	( SubMenuHandle`
				{	mSubHandle`		= mSubHandle
				,	mSubMenuId`		= mSubMenuId
				,	mSubOSMenuNr`	= mSubOSMenuNr
			//	,	mSubMacId`		= mSubMacId
				,	mSubItems`		= items`
				,	mSubTitle`		= mSubTitle
				,	mSubSelect`		= mSubSelect
			//	,	mSubLS`			= mSubLS
				,	mSubAtts`		= atts`
				}
			, SubMenuHandle
				{subH & mSubItems=items,mSubAtts=atts}
			)
		getMenuElementHandle (RadioMenuHandle radioH=:{mRadioId,mRadioIndex,mRadioItems=items,mRadioSelect,/*PA---mRadioLS,*/mRadioAtts=atts})
		#	(items`,items)			= getMenuElementHandles items
			(atts`, atts)			= getMenuAttributes atts
		=	( RadioMenuHandle`
				{	mRadioId`		= mRadioId
				,	mRadioIndex`	= mRadioIndex
				,	mRadioItems`	= items`
				,	mRadioSelect`	= mRadioSelect
			//	,	mRadioLS`		= mRadioLS
				,	mRadioAtts`		= atts`
				}
			, RadioMenuHandle
				{radioH & mRadioItems=items,mRadioAtts=atts}
			)
		getMenuElementHandle (MenuSeparatorHandle sepH=:{mSepId})//,mSepLS})
		=	(MenuSeparatorHandle` {mSepId`=mSepId}/*,mSepLS`=mSepLS}*/,MenuSeparatorHandle sepH)
		getMenuElementHandle (MenuListLSHandle items)
		#	(items`,items)		= getMenuElementHandles items
		=	(MenuListLSHandle` items`,MenuListLSHandle items)
		getMenuElementHandle (MenuExtendLSHandle exH=:{mExtendItems=items})
		#	(items`,items)		= getMenuElementHandles items
		=	(MenuExtendLSHandle` items`,MenuExtendLSHandle {exH & mExtendItems=items})
		getMenuElementHandle (MenuChangeLSHandle chH=:{mChangeItems=items})
		#	(items`,items)		= getMenuElementHandles items
		=	(MenuChangeLSHandle` items`,MenuChangeLSHandle {chH & mChangeItems=items})
		
		getMenuAttributes :: ![MenuAttribute .ps] -> (![MenuAttribute`],![MenuAttribute .ps])
		getMenuAttributes [att:atts]
		#	(ok,att`,att)	= getMenuAttribute  att
			(atts`, atts)	= getMenuAttributes atts
		|	ok				= ([att`:atts`],[att:atts])
							= (      atts`, [att:atts])
		where
			getMenuAttribute :: !(MenuAttribute .ps) -> (!Bool,!MenuAttribute`,!MenuAttribute .ps)
			getMenuAttribute att=:(MenuId			id)		= (True,MenuId`			 id,	 att)
			getMenuAttribute att=:(MenuSelectState	select)	= (True,MenuSelectState` select, att)
			getMenuAttribute att=:(MenuShortKey		keycode)= (True,MenuShortKey`	 keycode,att)
			getMenuAttribute att=:(MenuMarkState	mark)	= (True,MenuMarkState`	 mark,	 att)
			getMenuAttribute att							= (False,MenuShortKey`	 '0',	 att)
		getMenuAttributes _
		=	([],[])
	getMenuElementHandles _
	=	([],[])


setMenuHandle` :: !MenuHandle` !(MenuHandle .ls .ps) -> MenuHandle .ls .ps
setMenuHandle` mH`=:{mHandle`,mTitle`,mSelect`,mItems`} mH=:{mHandle,mItems}
|	mHandle`<>mHandle
=	mstateFatalError "setMenuHandle`" "mHandle` field <> mHandle field"
=	{mH & mItems=setMenuElementHandles mItems` mItems}
where
	setMenuElementHandles :: ![MenuElementHandle`] ![MenuElementHandle .ls .ps] -> [MenuElementHandle .ls .ps]
	setMenuElementHandles [itemH`:itemHs`] [itemH:itemHs]
	=	[setElementHandle itemH` itemH:setMenuElementHandles itemHs` itemHs]
	where
		setElementHandle :: !MenuElementHandle` !(MenuElementHandle .ls .ps) -> MenuElementHandle .ls .ps
		setElementHandle (MenuItemHandle` itemH`=:{mItemAtts`,mItemTitle`,mItemSelect`,mItemMark`})
						 (MenuItemHandle  itemH =:{mItemAtts})
		#	atts	= setMenuAttributes mItemAtts` mItemAtts
		=	MenuItemHandle {itemH & mItemAtts=atts,mItemTitle=mItemTitle`,mItemSelect=mItemSelect`,mItemMark=mItemMark`}
		setElementHandle (MenuReceiverHandle` recH`=:{mReceiverSelect`})
						 (MenuReceiverHandle  recH =:{mReceiverHandle=rH})
		=	MenuReceiverHandle {recH & mReceiverHandle={rH & rSelect=if mReceiverSelect` Able Unable}}	// PA: Bool to SelectState
		setElementHandle (SubMenuHandle` subH`=:{mSubItems`,mSubAtts`,mSubTitle`,mSubSelect`})
						 (SubMenuHandle  subH =:{mSubItems, mSubAtts})
		#	atts	= setMenuAttributes mSubAtts` mSubAtts
			items	= setMenuElementHandles mSubItems` mSubItems
		=	SubMenuHandle {subH & mSubItems=items,mSubAtts=atts,mSubTitle=mSubTitle`,mSubSelect=mSubSelect`}
		setElementHandle (RadioMenuHandle` radioH`=:{mRadioItems`,mRadioAtts`,mRadioSelect`,mRadioIndex`})
						 (RadioMenuHandle  radioH =:{mRadioItems, mRadioAtts})
		#	atts	= setMenuAttributes mRadioAtts` mRadioAtts
			items	= setMenuElementHandles mRadioItems` mRadioItems
		=	RadioMenuHandle {radioH & mRadioIndex=mRadioIndex`,mRadioItems=items,mRadioSelect=mRadioSelect`,mRadioAtts=atts}
		setElementHandle (MenuSeparatorHandle` _) sepH=:(MenuSeparatorHandle _)
		=	sepH
		setElementHandle (MenuListLSHandle` itemHs`) (MenuListLSHandle itemHs)
		=	MenuListLSHandle (setMenuElementHandles itemHs` itemHs)
		setElementHandle (MenuExtendLSHandle` itemHs`) (MenuExtendLSHandle exH=:{mExtendItems})
		=	MenuExtendLSHandle {exH & mExtendItems=setMenuElementHandles itemHs` mExtendItems}
		setElementHandle (MenuChangeLSHandle` itemHs`) (MenuChangeLSHandle chH=:{mChangeItems})
		=	MenuChangeLSHandle {chH & mChangeItems=setMenuElementHandles itemHs` mChangeItems}
		setElementHandle _ _
		=	mstateFatalError "setMenuHandle`" "MenuElementHandles do not match pairwise"
	setMenuElementHandles [] []
	=	[]
	setMenuElementHandles _ _
	=	mstateFatalError "setMenuHandle`" "incompatible number of MenuElementHandles"
	
	setMenuAttributes :: ![MenuAttribute`] ![MenuAttribute .ps] -> [MenuAttribute .ps]
	setMenuAttributes [att`:atts`] atts
	|	isConstantAttribute att`		= setMenuAttributes atts` atts
										= setMenuAttributes atts` (setAttribute att` atts)
	where
		isConstantAttribute (MenuId` _)	= True
		isConstantAttribute _			= False
		
		setAttribute :: !MenuAttribute` ![MenuAttribute .ps] -> [MenuAttribute .ps]
		setAttribute att` [att:atts]
		|	match att` att
		=	[att1:atts]
		=	[att :setAttribute att` atts]
		where
			att1	= case att` of
						(MenuSelectState`	select)	-> MenuSelectState	select
						(MenuShortKey`		keycode)-> MenuShortKey		keycode
						(MenuMarkState`		mark)	-> MenuMarkState	mark
						_							-> mstateFatalError "setMenuHandle" "illegal MenuAttribute` encountered"
			
			match (MenuSelectState` _) (MenuSelectState _)	= True
			match (MenuShortKey`	_) (MenuShortKey	_)	= True
			match (MenuMarkState`	_) (MenuMarkState	_)	= True
			match _						_					= False
		setAttribute att` _
		=	mstateFatalError "setMenuHandle" "non-matching MenuAttribute encountered"
	setMenuAttributes _ atts
	=	atts
